( function() {
    const { createElement } = window.wp.element;
    const { registerPaymentMethod } = window.wc.wcBlocksRegistry;

    const CapitalPayContent = () => {
        return createElement(
            'div',
            { className: 'capitalpay-content' },
            window.wc_capitalpay_params?.description || 'Pay via CapitalPay'
        );
    };

    registerPaymentMethod( {
        name: 'capitalpay',
        label: window.wc_capitalpay_params?.title || 'CapitalPay',
        ariaLabel: window.wc_capitalpay_params?.description || 'Pay via CapitalPay',
        content: CapitalPayContent(),
        edit: CapitalPayContent(),
        canMakePayment: () => true,
        supports: {
            features: window.wc_capitalpay_params?.supports || [ 'products' ]
        }
    } );
} )();
